package com.suncode.dbexplorer.database.schema;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;

public class DatabaseSchema
{
    private final String name;
    
    private final Map<String, TableSchema> tables = Maps.newLinkedHashMap();

    private final Map<String, Sequence> sequences = Maps.newLinkedHashMap();

    public DatabaseSchema( String name, List<TableSchema> tables, List<Sequence> sequences )
    {
        this.name = name;
        for ( TableSchema table : tables )
        {
            this.tables.put( table.getName(), table );
        }

        for ( Sequence sequence : sequences )
        {
            this.sequences.put( sequence.getName(), sequence );
        }
    }

    public String getName()
    {
        return name;
    }

    public boolean tableExists( String name )
    {
        return tables.containsKey( name );
    }

    public TableSchema getTable( String name )
    {
        TableSchema table = tables.get( name );
        if ( table == null )
        {
            throw new IllegalArgumentException( "Table [" + name + "] not found in " + this.name + " schema" );
        }
        return table;
    }

    public Map<String, TableSchema> getTables()
    {
        return Collections.unmodifiableMap( tables );
    }

    public Map<String, Sequence> getSequences()
    {
        return Collections.unmodifiableMap( sequences );
    }
}
