package com.suncode.dbexplorer.database.query;

import java.util.ArrayList;
import java.util.List;

import com.suncode.dbexplorer.database.RecordId;
import com.suncode.dbexplorer.database.schema.PrimaryKey;
import com.suncode.dbexplorer.database.schema.TableSchema;
import com.suncode.dbexplorer.database.type.DataType;

public class RecordIdEqCondition implements Condition {

	private final RecordId id;

	private final List<String> idColumns = new ArrayList<String>();

	public RecordIdEqCondition(RecordId id) {
		this.id = id;
	}

	@Override
	public String toSql(QueryContext queryContext) {
		TableSchema table = queryContext.getRootTable();
		if (!table.hasPrimaryKey()) {
			throw new IllegalStateException("Cannot apply RecordIdEqCondition because table [" + table
					+ "] does not have a primary key");
		}

		idColumns.clear();
		PrimaryKey pk = table.getPrimaryKey();
		if (!pk.isComposite()) {
			// SINGLE
			if (id.isComposite()) {
				throw new IllegalStateException("");
			}
			idColumns.add(pk.getColumn());
		}
		else {
			// COMPOSITE

			// TODO: walidacja czy PK jest zgodny z podanym ID

			idColumns.addAll(id.getCompositeValues().keySet());
		}

		StringBuilder sql = new StringBuilder();
		int i = 0;
		for (String column : idColumns) {
			sql
				.append(queryContext.getColumnAlias(column))
				.append("=?");

			if (i < idColumns.size() - 1) {
				sql.append(" AND ");
			}
			i++;
		}
		if (i > 1) {
			sql.insert(0, "(").append(")");
		}

		return sql.toString();
	}

	@Override
	public QueryParameter[] getParameters(QueryContext queryContext) {

		Object[] values;
		if (!id.isComposite()) {
			values = new Object[] { id.getSingleValue() };
		}
		else {
			values = id.getCompositeValues().values().toArray();
		}

		QueryParameter[] parameters = new QueryParameter[idColumns.size()];
		for (int i = 0; i < idColumns.size(); i++) {
			String column = idColumns.get(i);
			DataType type = queryContext.getTypeOf(column);

			parameters[i] = new QueryParameter(values[i], type);
		}
		return parameters;
	}

}
