package com.suncode.dbexplorer.database.query;

import lombok.Getter;
import lombok.Setter;
import org.springframework.util.Assert;

import com.suncode.dbexplorer.database.type.DataType;

@Getter
public class QueryParameter {

	public static final QueryParameter[] NONE = new QueryParameter[] {};

	private final Object value;

	private final DataType type;

	@Setter
	private String associatedColumn;

	public QueryParameter(Object value, DataType type) {
		Assert.notNull( type, "[Assertion failed] - this argument is required; it must not be null" );

		this.type = type;
		this.value = value;
	}
}
