package com.suncode.dbexplorer.database.query;

import com.google.common.collect.Lists;
import lombok.Setter;
import org.springframework.util.Assert;

import java.util.Collections;
import java.util.List;

public class Pagination
{
    private static final int DEFAULT_PAGE_SIZE = 50;

    private final int page;

    @Setter
    private int pageSize;

    private final List<Order> order = Lists.newArrayList();

    public Pagination( int page )
    {
        this( page, new Order[]{} );
    }

    public Pagination( int page, Order... order )
    {
        this( page, DEFAULT_PAGE_SIZE, order );
    }

    public Pagination( int page, int pageSize, Order... order )
    {
        this.page = page > 0 ? page : 1;
        this.pageSize = pageSize;
        Collections.addAll( this.order, order );
    }

    public int getPage()
    {
        return page;
    }

    public int getStart()
    {
        return ( ( page - 1 ) * pageSize );
    }

    public int getLimit()
    {
        return pageSize;
    }

    public List<Order> getOrder()
    {
        return order;
    }

    public boolean hasOrder()
    {
        return !order.isEmpty();
    }

    public void addOrder( Order order )
    {
        Assert.notNull( order, "[Assertion failed] - this argument is required; it must not be null" );
        this.order.add( order );
    }
}
