package com.suncode.dbexplorer.database.query;

public class NullCondition implements Condition {

	private String column;

	public NullCondition(String column) {
		this.column = column;
	}

	@Override
	public String toSql(QueryContext queryContext) {
		String alias = queryContext.getColumnAlias(column);
		StringBuilder sql = new StringBuilder()
			.append(alias)
			.append(" is NULL");

		return sql.toString();
	}

	@Override
	public QueryParameter[] getParameters(QueryContext queryContext) {
		return QueryParameter.NONE;
	}

}
