package com.suncode.dbexplorer.database.query;

import org.springframework.util.Assert;

import com.suncode.dbexplorer.database.type.DataType;

public class LikeCondition implements Condition {

	private final String column;
	private String value;
	private boolean caseSensitive;

	public LikeCondition(String column, String value, boolean caseSensitive) {
		Assert.notNull( value, "[Assertion failed] - this argument is required; it must not be null" );

		this.column = column;
		this.value = value;
		this.caseSensitive = caseSensitive;
	}

	@Override
	public String toSql(QueryContext queryContext) {
		String alias = queryContext.getColumnAlias(column);
		StringBuilder sql = new StringBuilder();
		if (!caseSensitive) {
			value = value.toUpperCase();
			sql.append("UPPER(")
				.append(alias)
				.append(")");
		}
		else {
			sql.append(alias);
		}

		sql.append(" LIKE ")
			.append("?");
		return sql.toString();
	}

	@Override
	public QueryParameter[] getParameters(QueryContext queryContext) {
		DataType type = queryContext.getTypeOf(column);
		return new QueryParameter[] { new QueryParameter(value, type) };
	}
}
