package com.suncode.dbexplorer.database.internal.type;

import org.hibernate.SQLQuery;

import com.suncode.dbexplorer.database.internal.type.hibernate.OtherType;
import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.NativeType;
import com.suncode.dbexplorer.database.type.UnknownDataType;

public class UnknownDataTypeHandler
    implements DataTypeHandler
{

    public UnknownDataTypeHandler()
    {
    }

    @Override
    public DataType create( NativeType nativeType )
    {
        return new UnknownDataType( nativeType );
    }

    @Override
    public void bindParameter( DataType dataType, String parameterName, Object value, SQLQuery query )
    {
        throw new UnsupportedOperationException( dataType.getNativeType().toString() );
    }

    @Override
    public void setScalar( DataType dataType, String columnAlias, SQLQuery query )
    {
        // tekstowa reprezentacja wartości (zależy tylko od sterownika JDBC)
        query.addScalar( columnAlias, OtherType.INSTANCE );
    }
}
