package com.suncode.dbexplorer.database.internal.type;

import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.NativeType;
import com.suncode.dbexplorer.database.type.TimeDataType;
import com.suncode.dbexplorer.util.convert.StringToDateConverter;

public class TimeDataTypeHandler extends HibernateDataTypeHandler {

	public TimeDataTypeHandler() {
	}

	@Override
	public DataType create(NativeType nativeType) {
		return new TimeDataType(nativeType);
	}

	@Override
	protected Object convert(Object value, Class<?> targetClass, DataType dataType) {
		if(value instanceof String){
			StringToDateConverter c = new StringToDateConverter();
			return c.convert((String) value);
		}
		throw new UnsupportedOperationException();
	}

	@Override
	protected Type resolveHibernateType(DataType dataType) {
		return StandardBasicTypes.TIME;
	}
}
