package com.suncode.dbexplorer.database.internal.type;

import java.sql.Types;

import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.util.NumberUtils;

import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.IntegerDataType;
import com.suncode.dbexplorer.database.type.NativeType;

public class IntegerDataTypeHandler extends HibernateDataTypeHandler {

	public IntegerDataTypeHandler() {
	}

	@Override
	public DataType create(NativeType nativeType) {
		return new IntegerDataType(nativeType);
	}

	@Override
	@SuppressWarnings("unchecked")
	protected Object convert(Object value, Class<?> targetClass, DataType dataType) {
		// TODO: sprawdzic czy np. 1.23 -> 1 działa (nie powinno!)

		if (value instanceof Number) {
			return NumberUtils.convertNumberToTargetClass((Number) value, (Class<? extends Number>) targetClass);
		}
		if (value instanceof String) {
			return NumberUtils.parseNumber((String) value, (Class<? extends Number>) targetClass);
		}
		throw new IllegalArgumentException();
	}

	@Override
	protected Type resolveHibernateType(DataType dataType) {
		int sqlType = dataType.getNativeType().getSqlType();

		// TODO: odczyt z a:dialect/b:przekazane jako konstruktor/c:niech typ mówi co wspiera??
		switch (sqlType) {
		case Types.TINYINT :
		case Types.SMALLINT:
			return StandardBasicTypes.SHORT;
		case Types.INTEGER:
			return StandardBasicTypes.INTEGER;
		case Types.BIGINT:
			return StandardBasicTypes.LONG;
		}
		throw new IllegalStateException();
	}
}
