package com.suncode.dbexplorer.database.internal.type;

import java.sql.Types;

import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.util.NumberUtils;

import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.FloatDataType;
import com.suncode.dbexplorer.database.type.NativeType;

public class FloatDataTypeHandler extends HibernateDataTypeHandler {

	public FloatDataTypeHandler() {
	}

	@Override
	public DataType create(NativeType nativeType) {
		return new FloatDataType(nativeType);
	}

	@Override
	@SuppressWarnings("unchecked")
	protected Object convert(Object value, Class<?> targetClass, DataType dataType) {
		// TODO: sprawdzic czy np. 1.23 -> 1 działa (nie powinno!)
		
		if (value instanceof Number) {
			return NumberUtils.convertNumberToTargetClass((Number) value, (Class<? extends Number>) targetClass);
		}
		if (value instanceof String) {
			return NumberUtils.parseNumber((String) value, (Class<? extends Number>) targetClass);
		}
		throw new IllegalArgumentException();
	}

	@Override
	protected Type resolveHibernateType(DataType dataType) {
		int sqlType = dataType.getNativeType().getSqlType();

		// TODO: odczyt z a:dialect/b:przekazane jako konstruktor/c:niech typ mówi co wspiera??
		switch (sqlType) {
		case Types.DECIMAL:
		case Types.NUMERIC:
			return StandardBasicTypes.BIG_DECIMAL;
		case Types.DOUBLE:
			return StandardBasicTypes.DOUBLE;
		case Types.FLOAT:
			return StandardBasicTypes.FLOAT;
		case Types.REAL:
			return StandardBasicTypes.FLOAT;
		}
		throw new IllegalStateException();
	}
}
