package com.suncode.dbexplorer.database.internal.type;

import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

import com.suncode.dbexplorer.database.type.BooleanDataType;
import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.NativeType;

public class BooleanDataTypeHandler extends HibernateDataTypeHandler {

	public BooleanDataTypeHandler() {
	}

	@Override
	public DataType create(NativeType nativeType) {
		return new BooleanDataType(nativeType);
	}

	@Override
	protected Object convert(Object value, Class<?> targetClass, DataType dataType) {
		return Boolean.valueOf(value.toString());
	}

	@Override
	protected Type resolveHibernateType(DataType dataType) {
		return StandardBasicTypes.BOOLEAN;
	}
}
