package com.suncode.dbexplorer.database.internal.sqlserver;

import java.util.List;

import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.internal.support.AbstractDatabaseImplementor;

@Component
public class SqlServerDatabase
		extends AbstractDatabaseImplementor
{
	public @Autowired SqlServerDatabase(SqlServerSchemaLoader schemaLoader, SqlServerConnectionUrlResolver urlResolver,
			SqlServerDataTypeRegistry typeRegistry)
	{
		super(DatabaseType.SQLSERVER, schemaLoader, urlResolver, typeRegistry);
	}

	@Override
	protected String getDriverClassName()
	{
		return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
	}

	@Override
	public String getCurrentSchemaName(DatabaseSession session)
	{
		return (String) session.hibernateSession()
			.createSQLQuery("select SCHEMA_NAME() as " + escapeColumnName("schema"))
			.addScalar("schema", StandardBasicTypes.STRING)
			.uniqueResult();
	}

	@Override
    @SuppressWarnings( "unchecked" )
    public List<String> getSchemasNames( DatabaseSession session )
    {
        return (List<String>) session.hibernateSession()
                        .createSQLQuery( "SELECT schema_name as 'schema' FROM INFORMATION_SCHEMA.SCHEMATA WHERE schema_name NOT IN ('guest', 'INFORMATION_SCHEMA', 'sys') AND schema_name NOT LIKE 'db[_]%'" )
                        .addScalar( "schema", StandardBasicTypes.STRING )
                        .list();
    }
}
