package com.suncode.dbexplorer.database.internal.sqlserver;

import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.internal.ConnectionUrlResolver;
import org.springframework.stereotype.Component;

@Component
public class SqlServerConnectionUrlResolver
    implements ConnectionUrlResolver
{
    @Override
    public String resolve( ConnectionString connectionString )
    {
        // jdbc:sqlserver://[serverName[\instanceName][:portNumber]][;property=value[;property=value]]

        StringBuilder url = new StringBuilder( "jdbc:sqlserver://" );
        url.append( connectionString.getHost() );

        Integer port = connectionString.getPort();
        if ( port != null )
        {
            url.append( ":" ).append( port );
        }

        url.append( ";databaseName=" )
            .append( connectionString.getCatalog() )
            .append( ";sendTimeAsDateTime=false" )
            .append( ";encrypt=false" );

        return url.toString();
    }
}
