package com.suncode.dbexplorer.database.internal.postgres.type;

import org.hibernate.SQLQuery;

import com.suncode.dbexplorer.database.internal.type.BooleanDataTypeHandler;
import com.suncode.dbexplorer.database.type.DataType;

public class PostgresBooleanTypeHandler extends BooleanDataTypeHandler {

	@Override
	public void bindParameter(DataType dataType, String parameterName, Object rawValue, SQLQuery query) {
		if ("bit".equals(dataType.getNativeType().getName())) {
			query.setParameter(parameterName, rawValue, PostgresBitType.INSTANCE);
		}
		else {
			super.bindParameter(dataType, parameterName, rawValue, query);
		}
	}
}
