package com.suncode.dbexplorer.database.internal.postgres;

import java.util.List;
import java.util.Map;

import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.internal.schema.jdbc.JdbcSchemaLoader;
import com.suncode.dbexplorer.database.schema.Sequence;

@Component
public class PostgresSchemaLoader
    extends JdbcSchemaLoader
{
    public @Autowired PostgresSchemaLoader( PostgresDataTypeRegistry dataTypeRegistry )
    {
        super( dataTypeRegistry );
    }

    @Override
    @SuppressWarnings( "unchecked" )
    protected List<Sequence> readSequences( DatabaseSession session, String schemaName )
    {
        // TODO: pewnie przenieść wyżej - do DatabaseImplementor
        // SELECT * FROM information_schema.sequences;
        
        List<Map<String, Object>> results = session.hibernateSession()
            .createSQLQuery( "SELECT c.relname as seqname FROM pg_class c WHERE c.relkind = 'S'" )
            .addScalar( "seqname", StandardBasicTypes.STRING )
            .setResultTransformer( Transformers.ALIAS_TO_ENTITY_MAP )
            .list();

        List<Sequence> sequences = Lists.newArrayList();
        for ( Map<String, Object> row : results )
        {
            String sequenceName = (String) row.get( "seqname" );
            sequences.add( new Sequence( sequenceName ) );
        }
        return sequences;
    }
}
