package com.suncode.dbexplorer.database.internal.db2as400;

import org.springframework.stereotype.Component;

import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.internal.ConnectionUrlResolver;

@Component
public class DB2AS400ConnectionUrlResolver
    implements ConnectionUrlResolver
{

    @Override
    public String resolve( ConnectionString connectionString )
    {
        // jdbc:as400://serverName:portNumber/DATABASE

        StringBuilder url = new StringBuilder( "jdbc:as400://" );
        url.append( connectionString.getHost() );

        Integer port = connectionString.getPort();
        if (port != null) {
            url.append(":").append(port);
        }
        url.append("/");

        if (connectionString.catalogSpecified()) {
            url.append(connectionString.getCatalog());
        }

        return url.toString();
    }
}
