package com.suncode.dbexplorer.database.internal;

import java.sql.Driver;
import java.util.List;

import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.internal.type.DataTypeRegistry;
import com.suncode.dbexplorer.database.schema.DatabaseSchema;

public interface DatabaseImplementor
{
	boolean handles(DatabaseType type);

	Class<? extends Driver> getDriverClass();

	DataTypeRegistry getTypeRegistry();

	String buildConnectionUrl(ConnectionString connectionString);

	String getCatalog(DatabaseSession session);

	String getCurrentSchemaName(DatabaseSession session);
	
	List<String> getSchemasNames(DatabaseSession session);

	List<DatabaseSchema> readSchemas(DatabaseSession session, List<String> schemasNames);

	String escapeColumnName(String columnName);

	String escapeTableName(String tableName);
}
