package com.suncode.dbexplorer.database;

import org.apache.commons.lang.StringUtils;

/**
 * @author Cezary Kozar 15 wrz 2015
 */
public enum DatabaseType
{
    POSTGRES,
    SQLSERVER,
    ORACLE,
    DB2,
    DB2AS400;

    public static DatabaseType parseScheme( String urlSchema )
    {
        for ( DatabaseType type : values() )
        {
            if ( StringUtils.containsIgnoreCase( urlSchema, type.name() )
                || StringUtils.containsIgnoreCase( type.name(), urlSchema ) )
            {
                return type;
            }
        }

        throw new RuntimeException( "Cannot resolve DatabaseType for " + urlSchema );
    }
}
