package com.suncode.dbexplorer.configurationtransfer.dto.alias.tableset.tables;

import com.suncode.dbexplorer.alias.dto.SimpleTableDto;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Component
public class ConfigurationTablesSetTableConverter
{
    public List<ConfigurationTablesSetTableDto> convertToDto( Set<SimpleTableDto> tables )
    {
        return tables.stream()
            .map( this::convertToDto )
            .collect( Collectors.toList() );
    }

    public ConfigurationTablesSetTableDto convertToDto( SimpleTableDto table )
    {
        return new ConfigurationTablesSetTableDto( table.getName(),
                                                   table.getSchema() );
    }

    public SimpleTableDto convertToEntity( ConfigurationTablesSetTableDto tableDto )
    {
        return new SimpleTableDto( tableDto.getSchema(),
                                   tableDto.getName() );
    }
}
