package com.suncode.dbexplorer.configurationtransfer.dto.alias.settings;

import com.suncode.pwfl.configuration.dto.ConfigurationDtoConfigObject;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class ConfigurationTableSettingDto
    extends ConfigurationDtoConfigObject
{
    private String schemaName;

    private String tableName;

    private String displayName;

    private ConfigurationColumnSettingsContainer columnsSettings = new ConfigurationColumnSettingsContainer();

    public ConfigurationTableSettingDto( String schemaName,
                                         String tableName,
                                         String displayName,
                                         List<ConfigurationColumnSettingDto> columnsSettings )
    {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.displayName = displayName;
        this.columnsSettings.getList().addAll( columnsSettings );
    }
}
