package com.suncode.dbexplorer.configurationtransfer.dto.alias.settings;

import com.suncode.dbexplorer.alias.settings.ColumnSettings;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component
public class ConfigurationColumnSettingsConverter
{
    public List<ConfigurationColumnSettingDto> convertToDto( Map<String, ColumnSettings> columnsSettings )
    {
        List<ConfigurationColumnSettingDto> columnSettingsDtos = new ArrayList<>();

        columnsSettings.values()
            .forEach( columnSetting -> columnSettingsDtos.add( new ConfigurationColumnSettingDto( columnSetting.getColumnName(),
                                                                                                  columnSetting.getDisplayName() ) ) );

        return columnSettingsDtos;
    }

    public ColumnSettings convertToEntity( ConfigurationColumnSettingDto columnSettingsDto )
    {
        ColumnSettings columnSettings = new ColumnSettings( columnSettingsDto.getColumnName() );

        if ( StringUtils.isNotBlank( columnSettingsDto.getDisplayName() ) )
        {
            columnSettings.setDisplayName( columnSettingsDto.getDisplayName() );
        }

        return columnSettings;
    }
}
