package com.suncode.dbexplorer.configurationtransfer.dto.alias;

import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.pwfl.configuration.dto.ConfigurationDtoConfigObject;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@NoArgsConstructor
public class ConfigurationConnectionStringDomainDto
    extends ConfigurationDtoConfigObject
{
    private Long id;

    private DatabaseType type;

    private String catalog;

    private String schema;

    private String host;

    private Integer port;

    private String user;

    private String password;

    private String jdbcUrl;

    public ConfigurationConnectionStringDomainDto( Long id, DatabaseType type, String catalog, String schema, String host, Integer port, String user,
                                                   String password, String jdbcUrl )
    {
        this.id = id;
        this.type = type;
        this.catalog = catalog;
        this.schema = schema;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.jdbcUrl = jdbcUrl;

        this.getMetadata().setHidden( true );
    }
}
