package com.suncode.dbexplorer.configurationtransfer;

import com.suncode.dbexplorer.alias.AliasService;
import com.suncode.dbexplorer.configurationtransfer.dto.ConfigurationDbExplorerRootDto;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.ConfigurationAliasConverter;
import com.suncode.plugin.framework.Plugin;
import com.suncode.pwfl.configuration.dto.plugins.PluginConfigurationDtoRoot;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@RequiredArgsConstructor( onConstructor_ = { @Autowired } )
public class ConfigurationExporter
{
    private final Plugin plugin;

    private final AliasService aliasService;

    private final ConfigurationAliasConverter configurationAliasConverter;

    @Transactional( readOnly = true )
    public PluginConfigurationDtoRoot exportConfig()
    {
        return new ConfigurationDbExplorerRootDto( plugin.getKey(), plugin.getName(),
                                                   configurationAliasConverter.convertToDto( aliasService.getAliases() ) );
    }
}
