package com.suncode.dbexplorer.audit;

import com.suncode.pwfl.audit.plugin.PluginAuditProvider;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class AuditProvider
    implements PluginAuditProvider
{
    private final transient Translator translator = Translators.get( AuditProvider.class );

    @Override
    public Map<String, String> getPluginAudits()
    {
        Map<String, String> pluginAudits = new HashMap<>();
        for ( AuditTypes audit : AuditTypes.values() )
        {
            pluginAudits.put( audit.getValue(), translator.getMessage( audit.getValue() ) );
        }

        return pluginAudits;
    }
}
