package com.suncode.dbexplorer.alias.settings;

import java.util.Collections;
import java.util.Map;

import jakarta.persistence.Transient;

import org.springframework.util.Assert;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import lombok.Getter;
import lombok.Setter;

@JsonIgnoreProperties( ignoreUnknown = true )
@Getter
public class TableSettings
{
    private String schemaName;

    private String tableName;

    @Setter
    private String displayName;

    @Setter
    private boolean logging;

    @Transient
    private Map<String, ColumnSettings> columnsSettings = Maps.newHashMap();

    @JsonCreator
    public TableSettings( @JsonProperty( "schemaName" ) String schemaName, @JsonProperty( "tableName" ) String tableName )
    {
        Assert.hasText( tableName, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank" );
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public Map<String, ColumnSettings> getColumnsSettings()
    {
        return Collections.unmodifiableMap( columnsSettings );
    }

    public ColumnSettings getColumnSettings( String columnName )
    {
        ColumnSettings settings = columnsSettings.get( columnName );
        if ( settings == null )
        {
            settings = new ColumnSettings( columnName );
            addColumnSettings( settings );
        }
        return settings;
    }

    public void addColumnSettings( ColumnSettings settings )
    {
        this.columnsSettings.put( settings.getColumnName(), settings );
    }
}
