package com.suncode.dbexplorer.alias.settings;

import java.util.Collections;
import java.util.Map;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Transient;

import com.google.common.collect.Maps;
import com.suncode.dbexplorer.util.persistence.Json;

/**
 * @author Cezary Kozar 9 gru 2015
 */
@Embeddable
@AttributeOverride( name = Json.COLUMN, column = @Column( name = "settings" ) )
public class Settings
    extends Json<Settings>
{
    @Transient
    private Map<String, TableSettings> tablesSettings = Maps.newHashMap();
    
    public Settings()
    {
    }

    @Override
    protected void apply( Settings serialized )
    {
        this.tablesSettings = serialized.tablesSettings;
    }

    public TableSettings getTableSettings( String schema, String table )
    {
        TableSettings settings = tablesSettings.get( prepareKey( schema, table ) );
        if ( settings == null )
        {
            settings = new TableSettings( schema, table );
            addTablesSettings( settings );
        }
        return settings;
    }

    public Map<String, TableSettings> getTablesSettings()
    {
        return Collections.unmodifiableMap( tablesSettings );
    }

    public void addTablesSettings( TableSettings settings )
    {
        this.tablesSettings.put( prepareKey( settings.getSchemaName(), settings.getTableName() ), settings );
    }

    private String prepareKey( String schema, String table )
    {
        return schema + "." + table;
    }
}
