package com.suncode.dbexplorer.alias.settings;

import org.springframework.util.Assert;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties( ignoreUnknown = true )
public class ColumnSettings
{
    private String columnName;

    private String displayName;

    @JsonCreator
    public ColumnSettings( @JsonProperty( "columnName" ) String columnName )
    {
        Assert.hasText( columnName, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank" );
        this.columnName = columnName;
    }

    public String getColumnName()
    {
        return columnName;
    }

    public String getDisplayName()
    {
        return displayName;
    }

    public void setDisplayName( String displayName )
    {
        this.displayName = displayName;
    }
}
