package com.suncode.dbexplorer.alias.permission;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;

import org.springframework.util.Assert;

import com.suncode.dbexplorer.alias.TablesSet;

/**
 * @author Cezary Kozar 16 lis 2015
 */
@Entity
@Table( uniqueConstraints = @UniqueConstraint( columnNames = { "tables_set", "resource_type", "resource_id" } ) )
public class TablesSetPermission
{
    private static final String SEQ = "dbex_tables_set_access_id";

    @Id
    @GeneratedValue( generator = SEQ )
    @SequenceGenerator( name = SEQ, sequenceName = SEQ )
    private Long id;

    @ManyToOne( optional = false, fetch = FetchType.EAGER )
    @JoinColumn( name = "tables_set", nullable = false )
    private TablesSet tablesSet;

    @Enumerated( EnumType.STRING )
    @Column( name = "`level`", nullable = false )
    private AccessLevel level;

    @Embedded
    @AttributeOverrides( {
                          @AttributeOverride( name = "id", column = @Column( name = "resource_id" ) ),
                          @AttributeOverride( name = "type", column = @Column( name = "resource_type" ) )
    } )
    private AccessResource resource;

    @SuppressWarnings( "unused" )
    private TablesSetPermission()
    {
    }

    public TablesSetPermission( TablesSet set, AccessLevel level, AccessResource resource )
    {
        Assert.notNull( set, "[Assertion failed] - this argument is required; it must not be null" );
        Assert.notNull( level, "[Assertion failed] - this argument is required; it must not be null" );
        Assert.notNull( resource, "[Assertion failed] - this argument is required; it must not be null" );

        this.tablesSet = set;
        this.level = level;
        this.resource = resource;
    }

    public Long getId()
    {
        return id;
    }

    public TablesSet getTablesSet()
    {
        return tablesSet;
    }

    public AccessLevel getLevel()
    {
        return level;
    }

    public void setLevel( AccessLevel level )
    {
        this.level = level;
    }

    public AccessResource getResource()
    {
        return resource;
    }
}