package com.suncode.dbexplorer.alias.permission;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Transient;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import com.suncode.dbexplorer.util.persistence.Injectable;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;

@Embeddable
@Injectable
public class AccessResource
{
    public enum ResourceType
    {
        USER, GROUP;
    }

    @Column( nullable = false )
    private Long id;

    @Enumerated( EnumType.STRING )
    @Column( nullable = false )
    private ResourceType type;

    @Autowired
    @Transient
    private UserService userService;

    @Transient
    private User user;

    @Transient
    private UserGroup group;

    @SuppressWarnings( "unused" )
    private AccessResource()
    {
    }

    public AccessResource( User user )
    {
        Assert.notNull( user, "[Assertion failed] - this argument is required; it must not be null" );

        this.user = user;
        this.id = user.getObjectId();
        this.type = ResourceType.USER;
    }

    public AccessResource( UserGroup group )
    {
        Assert.notNull( group, "[Assertion failed] - this argument is required; it must not be null" );

        this.group = group;
        this.id = group.getObjectId();
        this.type = ResourceType.GROUP;
    }

    public ResourceType getType()
    {
        return type;
    }

    public User getUser()
    {
        if ( type == ResourceType.USER && user == null )
        {
            Assert.state( userService != null, "[Assertion failed] - this state invariant must be true" );
            user = userService.getUser( id );
        }
        return user;
    }

    public UserGroup getGroup()
    {
        if ( type == ResourceType.GROUP && group == null )
        {
            Assert.state( userService != null, "[Assertion failed] - this state invariant must be true" );
            group = userService.getGroup( id );
        }
        return group;
    }
}
