package com.suncode.dbexplorer.alias.dto;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;

@Embeddable
public class SimpleTableDto
{
    @Column( name = "schema_name" )
    private String schema;
    
    private String name;

    public SimpleTableDto()
    {
    }
    
    public SimpleTableDto( String schema, String name )
    {
        this.schema = schema;
        this.name = name;
    }

    public void setSchema( String schema )
    {
        this.schema = schema;
    }

    public void setName( String name )
    {
        this.name = name;
    }

    public String getSchema()
    {
        return schema;
    }

    public String getName()
    {
        return name;
    }

    @Override
    public int hashCode()
    {
        final int prime = 31;
        int result = 1;
        result = prime * result + ( ( name == null ) ? 0 : name.hashCode() );
        result = prime * result + ( ( schema == null ) ? 0 : schema.hashCode() );
        return result;
    }

    @Override
    public boolean equals( Object obj )
    {
        if ( this == obj )
            return true;
        if ( obj == null )
            return false;
        if ( getClass() != obj.getClass() )
            return false;
        SimpleTableDto other = (SimpleTableDto) obj;
        if ( name == null )
        {
            if ( other.name != null )
                return false;
        }
        else if ( !name.equals( other.name ) )
            return false;
        if ( schema == null )
        {
            if ( other.schema != null )
                return false;
        }
        else if ( !schema.equals( other.schema ) )
            return false;
        return true;
    }

    @Override public String toString()
    {
        return "[" + schema + "]" + name;
    }
}
