package com.suncode.dbexplorer.alias.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.Column;
import com.suncode.dbexplorer.alias.Table;
import com.suncode.dbexplorer.database.schema.ColumnSchema;

@JsonIgnoreProperties( ignoreUnknown = true )
public class ColumnDto
{
    private Long aliasId;

    private String schemaName;
    
    private String tableName;

    private String name;

    private String displayName;

    private String type;

    private Integer length;

    private boolean nullable;

    private boolean autoIncrement;
    
    private boolean unique;

    public ColumnDto()
    {
    }

    public ColumnDto( Alias alias, Table table, Column column )
    {
        this.schemaName = table.getSchema();
        this.tableName = table.getName();
        this.aliasId = alias.getId();
        this.name = column.getName();
        this.displayName = column.getDisplayName();

        ColumnSchema schema = column.getColumnSchema();
        this.type = schema.getType().getName();
        this.length = schema.getType().getNativeType().getLength();
        this.nullable = schema.isNullable();
        this.autoIncrement = schema.isAutoIncrement();
        this.unique = schema.isUnique();
    }

    public static List<ColumnDto> from( Alias alias, Table table, Collection<Column> columns )
    {
        List<ColumnDto> dtos = new ArrayList<ColumnDto>();
        for ( Column column : columns )
        {
            dtos.add( new ColumnDto( alias, table, column ) );
        }
        return dtos;
    }

    public Long getAliasId()
    {
        return aliasId;
    }

    public void setAliasId( Long aliasId )
    {
        this.aliasId = aliasId;
    }

    public String getSchemaName()
    {
        return schemaName;
    }

    public String getTableName()
    {
        return tableName;
    }

    public void setTableName( String tableName )
    {
        this.tableName = tableName;
    }

    public String getName()
    {
        return name;
    }

    public void setName( String name )
    {
        this.name = name;
    }

    public String getDisplayName()
    {
        return displayName;
    }

    public void setDisplayName( String displayName )
    {
        this.displayName = displayName;
    }

    public String getType()
    {
        return type;
    }

    public void setType( String type )
    {
        this.type = type;
    }

    public Integer getLength()
    {
        return length;
    }

    public void setLength( Integer length )
    {
        this.length = length;
    }

    public boolean isNullable()
    {
        return nullable;
    }

    public void setNullable( boolean nullable )
    {
        this.nullable = nullable;
    }

    public boolean isAutoIncrement()
    {
        return autoIncrement;
    }

    public void setAutoIncrement( boolean autoIncrement )
    {
        this.autoIncrement = autoIncrement;
    }

    public boolean isUnique()
    {
        return unique;
    }

    public void setUnique( boolean unique )
    {
        this.unique = unique;
    }
}
