package com.suncode.dbexplorer.alias.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.DatabaseType;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@NoArgsConstructor
public class AliasDto
{
    private Long id;

    private String name;

    private String catalog;

    private DatabaseType type;

    private String host;

    private Integer port;

    private String jdbcUrl;

    private String user;

    private String password;

    private Boolean isSystemAlias;

    private Boolean isActive;

    private String displayedName;

    private Boolean logging;

    private Boolean isJdbcUrlConfig;

    public AliasDto( Alias alias )
    {
        this.id = alias.getId();
        this.name = alias.getName();
        this.isSystemAlias = alias.getIsSystemAlias();
        this.isActive = alias.getIsActive();
        this.logging = alias.getLogging();
        this.isJdbcUrlConfig = alias.getIsJdbcUrlConfig();

        ConnectionString connection = alias.getWrappedConnectionString();
        this.catalog = connection.getCatalog();
        this.host = connection.getHost();
        this.port = connection.getPort();
        this.user = connection.getUser();
        this.password = connection.getPassword();
        this.type = connection.getType();
        this.jdbcUrl = connection.getJdbcUrl();
    }

    public static AliasDto from( Alias alias )
    {
        return new AliasDto( alias );
    }

    @JsonIgnore
    public ConnectionString getConnectionString()
    {
        // TODO: SCHEMA-SUPPORT
        return ConnectionString.builder()
            .type( type )
            .catalog( catalog )
            .host( host )
            .port( port )
            .user( user )
            .password( password )
            .jdbcUrl( jdbcUrl )
            .build();
    }
}
