package com.suncode.dbexplorer.alias.data;

import java.util.HashSet;
import java.util.Set;

import com.suncode.dbexplorer.database.type.BasicDataType;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;
import lombok.Setter;

@Getter
public class CreateTable
{
    private String name;

    private String schema;

    private Set<Column> columns;

    @Setter
    private Set<ForeignKey> foreignKeys;

    public CreateTable( String name, Set<Column> columns )
    {
        this( "", name, columns );
    }

    public CreateTable( String schema, String name, Set<Column> columns )
    {
        foreignKeys = new HashSet<>();
        this.name = name;
        this.schema = schema;
        this.columns = columns;
    }

    @Getter
    @Setter
    @RequiredArgsConstructor
    public static class Column
    {
        @NonNull
        @Setter(AccessLevel.NONE)
        private String name;

        @NonNull
        @Setter(AccessLevel.NONE)
        private BasicDataType dataType;

        private boolean nullable;

        private boolean autoIncrement;

        private boolean primaryKey;

    }

    @Getter
    @AllArgsConstructor
    public static class ForeignKey
    {
        private String columnName;

        private String foreignTableName;

        private String foreignColumnName;
    }
}
