package com.suncode.dbexplorer.alias;

import java.util.Collection;
import java.util.Set;

import jakarta.persistence.*;

import jakarta.persistence.Column;
import jakarta.persistence.Table;
import org.springframework.util.Assert;

import com.google.common.collect.Sets;
import com.suncode.dbexplorer.alias.dto.SimpleTableDto;
import com.suncode.dbexplorer.alias.permission.TablesSetPermission;
import com.suncode.dbexplorer.util.persistence.BaseEntity;

@Entity
@Table( uniqueConstraints = @UniqueConstraint( columnNames = "name" ) )
public class TablesSet
    extends BaseEntity
{
    @ManyToOne( optional = false )
    @JoinColumn( name="alias", nullable = false )
    private Alias alias;

    @Column( nullable = false )
    private String name;

    @AttributeOverrides({ @AttributeOverride(name = "name", column = @Column(name = "tables")) })
    @ElementCollection( fetch = FetchType.EAGER )
    @CollectionTable(name="tables_set_tables", joinColumns = @JoinColumn( name = "tables_set"))
    private Set<SimpleTableDto> tables = Sets.newLinkedHashSet();

    @OneToMany( mappedBy = "tablesSet", cascade = CascadeType.ALL, orphanRemoval = true, fetch = FetchType.LAZY )
    private Set<TablesSetPermission> permissions = Sets.newHashSet();

    @SuppressWarnings( "unused" )
    private TablesSet()
    {
    }

    public TablesSet( String name )
    {
        this( name, null );
    }

    public TablesSet( String name, Collection<SimpleTableDto> tables )
    {
        Assert.hasText( name, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank" );
        this.name = name;
        if ( tables != null )
        {
            this.tables.addAll( tables );
        }
    }

    public Alias getAlias()
    {
        return alias;
    }

    void setAlias( Alias alias )
    {
        this.alias = alias;
    }

    public String getName()
    {
        return name;
    }

    public void setName( String name )
    {
        this.name = name;
    }

    public Set<SimpleTableDto> getTables()
    {
        return tables;
    }

    public void setTablesNames( Collection<SimpleTableDto> tables )
    {
        this.tables.clear();
        this.tables.addAll( tables );
    }

    public Set<TablesSetPermission> getPermissions()
    {
        return permissions;
    }

    public void setPermissions( Set<TablesSetPermission> permissions )
    {
        this.permissions = permissions;
    }
}
