package com.suncode.dbexplorer.alias;

import com.google.common.collect.Maps;
import com.suncode.dbexplorer.alias.settings.TableSettings;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import com.suncode.dbexplorer.database.schema.PrimaryKey;
import com.suncode.dbexplorer.database.schema.TableSchema;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Table
{
    private final TableSchema table;

    private final TableSettings settings;

    private final Map<String, Column> columns = Maps.newLinkedHashMap();

    public Table( TableSchema table, TableSettings settings )
    {
        Assert.notNull( table, "[Assertion failed] - this argument is required; it must not be null" );
        Assert.notNull( settings, "[Assertion failed] - this argument is required; it must not be null" );
        Assert.state( table.getName().equals( settings.getTableName() ), "[Assertion failed] - this state invariant must be true" );

        this.table = table;
        this.settings = settings;

        for ( ColumnSchema column : table.getColumns() )
        {
            Column col = new Column( column, settings.getColumnSettings( column.getName() ) );
            columns.put( column.getName(), col );
        }
    }

    public TableSchema getTableSchema()
    {
        return table;
    }
    
    public String getSchema()
    {
        return table.getSchema();
    }

    public String getName()
    {
        return table.getName();
    }

    public boolean isView()
    {
        return table.isView();
    }

    public String getDisplayName()
    {
        return settings.getDisplayName();
    }

    public boolean getLogging()
    {
        return settings.isLogging();
    }

    public PrimaryKey getPrimaryKey()
    {
        return table.getPrimaryKey();
    }

    public List<Column> getColumns()
    {
        return new ArrayList<Column>( columns.values() );
    }
}
