package com.suncode.dbexplorer.alias;

import java.util.List;

/**
 * Serwis obsługujący zapisane konfiguracje bazy danych (Aliasy).
 * 
 * @author Cezary Kozar 2 gru 2015
 */
public interface AliasService
{
    /**
     * Zapisuje podany alias bazy danych.
     * 
     * @param alias konfiguracja bazy danych
     */
    void addAlias( Alias alias );

    /**
     * Usuwa alias bazy danych o podanym identyfikatorze.
     * 
     * @param id identyfikator aliasu ({@link Alias#getId()}
     */
    void deleteAlias( Long id );

    /**
     * Zapisuje wszystkie zmiany wprowadzone w zachowanej instancji aliasu.
     * 
     * @param alias konfiguracja bazy danych
     */
    void updateAlias( Alias alias );

    /**
     * Wczytuje zapisany alias o podanym identyfikatorze
     * 
     * @param id identyfikator aliasu
     * @return odczytana konfiguracja bazy danych lub {@code null} jeżeli taki alias nie istnieje
     */
    Alias getAlias( Long id );

    /**
     * Wczytuje zapisany alias o podanej nazwie.
     * 
     * @param name nazwa aliasu {@link Alias#getName()}
     * @return odczytana konfiguracja bazy danych lub {@code null} jeżeli taki alias nie istnieje
     */
    Alias getAlias( String name );

    /**
     * Zwraca wszystkie zapiasane konfiguracje baz danych.
     *
     * @return lista konfiguracji baz danych
     */
    List<Alias> getAliases();

    /**
     * Zwraca wszystkie aktywne zapisane konfiguracje baz danych.
     *
     * @return lista konfiguracji baz danych
     */
    List<Alias> getActiveAliases();

    /**
     * Dodatnie aliasu systemowej bazy danych
     *
     * @return stworzony alias
     */
    Alias addSystemAlias();
}
