/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.util.web;

import com.suncode.dbexplorer.util.authorization.AuthorizationHelper;
import java.sql.SQLException;
import org.enhydra.shark.Shark;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ViewController {
    private static final String CONFIGURATION_VIEW = "config";
    private static final String EXPLORER_VIEW = "explorer";
    private static final String DECIMAL_SEPARATOR = Shark.getInstance().getProperties().getProperty("DecimalSeparator", ".");
    private final AuthorizationHelper authorizationHelper;

    @RequestMapping(value={"/"})
    public String explorer(@RequestParam(required=false) Boolean debug, Model model) {
        model.addAttribute("decimalSeparator", (Object)DECIMAL_SEPARATOR);
        model.addAttribute("debug", (Object)debug);
        return EXPLORER_VIEW;
    }

    @RequestMapping(value={"/configure"})
    public String configuration(@RequestParam(required=false) Boolean debug, Model model) throws SQLException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        model.addAttribute("debug", (Object)debug);
        return CONFIGURATION_VIEW;
    }

    @Autowired
    public ViewController(AuthorizationHelper authorizationHelper) {
        this.authorizationHelper = authorizationHelper;
    }
}

