/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.providers;

import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.AliasService;
import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.internal.DatabaseFactoryImpl;
import com.suncode.dbexplorer.database.internal.DatabaseImplementor;
import com.suncode.pwfl.plugin.modules.dbconfig.DatabaseConnectionConfig;
import com.suncode.pwfl.plugin.modules.dbconfig.DatabaseConnectionConfigProvider;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DatabaseProvider
implements DatabaseConnectionConfigProvider {
    @Autowired
    private DatabaseFactoryImpl databaseFactoryImpl;
    @Autowired
    private AliasService aliasService;

    public List<DatabaseConnectionConfig> getDatabaseConnectionConfigs() {
        LinkedList<DatabaseConnectionConfig> configs = new LinkedList<DatabaseConnectionConfig>();
        for (Alias alias : this.aliasService.getActiveAliases()) {
            ConnectionString connString = alias.getWrappedConnectionString();
            DatabaseConnectionConfig config = new DatabaseConnectionConfig();
            config.setId("" + alias.getId());
            config.setName(alias.getName());
            config.setUsername(connString.getUser());
            config.setPassword(connString.getPassword());
            DatabaseImplementor dbImplementor = this.databaseFactoryImpl.resolveDatabaseType(connString);
            config.setDriverClassName(dbImplementor.getDriverClass().getName());
            config.setJdbcUrl(dbImplementor.buildConnectionUrl(connString));
            configs.add(config);
        }
        return configs;
    }
}

