/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.type.support;

import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.type.BasicDataType;

public class TypeConventer {
    public static String convert(BasicDataType type, DatabaseType database) {
        return TypeConventer.getType(type, database);
    }

    private static String getType(BasicDataType type, DatabaseType database) {
        if (type == BasicDataType.INTEGER) {
            return TypeConventer.convertInteger();
        }
        if (type == BasicDataType.STRING) {
            return TypeConventer.convertString(database);
        }
        if (type == BasicDataType.BOOLEAN) {
            return TypeConventer.convertBoolean(database);
        }
        if (type == BasicDataType.BINARY) {
            return TypeConventer.convertBinary(database);
        }
        if (type == BasicDataType.DATE) {
            return TypeConventer.convertDate();
        }
        if (type == BasicDataType.DATETIME) {
            return TypeConventer.convertDateTime(database);
        }
        if (type == BasicDataType.FLOAT) {
            return TypeConventer.convertFloat(database);
        }
        if (type == BasicDataType.TIME) {
            return TypeConventer.convertTime(database);
        }
        throw new RuntimeException("Cannot convert BasicDataType for " + type);
    }

    private static String convertInteger() {
        return "INTEGER";
    }

    private static String convertString(DatabaseType database) {
        if (database == DatabaseType.ORACLE) {
            return "VARCHAR2(4000)";
        }
        return "VARCHAR(4000)";
    }

    private static String convertBoolean(DatabaseType database) {
        if (database == DatabaseType.SQLSERVER) {
            return "BIT";
        }
        if (database == DatabaseType.ORACLE) {
            return "NUMBER(1)";
        }
        return "BOOLEAN";
    }

    private static String convertBinary(DatabaseType database) {
        if (database == DatabaseType.POSTGRES) {
            return "BYTEA";
        }
        if (database == DatabaseType.ORACLE) {
            return "BINARY_DOUBLE";
        }
        return "BINARY(7500)";
    }

    private static String convertDate() {
        return "DATE";
    }

    private static String convertDateTime(DatabaseType database) {
        if (database == DatabaseType.SQLSERVER) {
            return "DATETIME";
        }
        return "TIMESTAMP";
    }

    private static String convertFloat(DatabaseType database) {
        if (database == DatabaseType.POSTGRES) {
            return "DOUBLE PRECISION";
        }
        if (database == DatabaseType.ORACLE) {
            return "FLOAT(15)";
        }
        return "FLOAT";
    }

    private static String convertTime(DatabaseType database) {
        if (database == DatabaseType.ORACLE) {
            throw new RuntimeException("Oracle databases do not support TIME type.");
        }
        return "TIME";
    }
}

