/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.schema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import com.suncode.dbexplorer.database.schema.PrimaryKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class TableSchema {
    private final String schema;
    private final String name;
    private final boolean view;
    private final Map<String, ColumnSchema> columns;
    private final PrimaryKey primaryKey;

    public TableSchema(String schema, String name, boolean view, List<ColumnSchema> columns, PrimaryKey primaryKey) {
        this.schema = schema;
        this.name = name;
        this.primaryKey = primaryKey;
        this.view = view;
        LinkedHashMap<String, ColumnSchema> columnsMap = new LinkedHashMap<String, ColumnSchema>();
        for (ColumnSchema column : columns) {
            columnsMap.put(column.getName(), column);
        }
        this.columns = ImmutableMap.copyOf(columnsMap);
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        StringBuilder result = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)this.schema)) {
            result.append(this.schema);
            result.append(".");
        }
        result.append(this.name);
        return result.toString();
    }

    public boolean isView() {
        return this.view;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public boolean hasPrimaryKey() {
        return this.primaryKey != null;
    }

    public ColumnSchema[] getPrimaryKeyColumns() {
        Assert.state((boolean)this.hasPrimaryKey(), (String)"[Assertion failed] - this state invariant must be true");
        ArrayList<ColumnSchema> result = new ArrayList<ColumnSchema>();
        for (String pkColumn : this.primaryKey.getColumns()) {
            result.add(this.columns.get(pkColumn));
        }
        return (ColumnSchema[])Iterables.toArray(result, ColumnSchema.class);
    }

    public List<ColumnSchema> getColumns() {
        return new ArrayList<ColumnSchema>(this.columns.values());
    }

    public ColumnSchema getColumn(String name) {
        if (!this.columns.containsKey(name)) {
            throw new IllegalArgumentException("Column [" + name + "] is not part of [" + this.name + "] table");
        }
        return this.columns.get(name);
    }

    public boolean hasColumn(String name) {
        return this.columns.containsKey(name);
    }

    public Set<String> getColumnNames() {
        HashSet names = Sets.newHashSet();
        for (ColumnSchema column : this.columns.values()) {
            names.add(column.getName());
        }
        return names;
    }
}

