/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.query;

import com.suncode.dbexplorer.database.RecordId;
import com.suncode.dbexplorer.database.query.AndOrCondition;
import com.suncode.dbexplorer.database.query.Condition;
import com.suncode.dbexplorer.database.query.LikeCondition;
import com.suncode.dbexplorer.database.query.NotCondition;
import com.suncode.dbexplorer.database.query.NullCondition;
import com.suncode.dbexplorer.database.query.OperatorCondition;
import com.suncode.dbexplorer.database.query.RecordIdEqCondition;
import java.util.Date;
import org.joda.time.LocalDateTime;

public abstract class Conditions {
    public static Condition not(Condition condition) {
        return new NotCondition(condition);
    }

    public static Condition isNull(String column) {
        return new NullCondition(column);
    }

    public static Condition eqOrIsNull(String column, Object value) {
        return Conditions.or(Conditions.eq(column, value), Conditions.isNull(column));
    }

    public static Condition eq(String column, Object value) {
        if (value == null) {
            return Conditions.isNull(column);
        }
        return new OperatorCondition(column, OperatorCondition.Operator.EQ, value);
    }

    public static Condition idEq(RecordId id) {
        return new RecordIdEqCondition(id);
    }

    public static Condition and(Condition ... conditions) {
        return new AndOrCondition(AndOrCondition.Type.AND, conditions);
    }

    public static Condition or(Condition ... conditions) {
        return new AndOrCondition(AndOrCondition.Type.OR, conditions);
    }

    public static Condition ge(String column, Object value) {
        return new OperatorCondition(column, OperatorCondition.Operator.GE, value);
    }

    public static Condition gt(String column, Object value) {
        return new OperatorCondition(column, OperatorCondition.Operator.GT, value);
    }

    public static Condition le(String column, Object value) {
        return new OperatorCondition(column, OperatorCondition.Operator.LE, value);
    }

    public static Condition lt(String column, Object value) {
        return new OperatorCondition(column, OperatorCondition.Operator.LT, value);
    }

    public static Condition like(String column, String value) {
        return new LikeCondition(column, value, true);
    }

    public static Condition ilike(String column, String value) {
        return new LikeCondition(column, value, false);
    }

    public static Condition withinMinutes(String column, int minutesAmount) {
        LocalDateTime now = LocalDateTime.now().minusMinutes(minutesAmount);
        return Conditions.withinDate(column, now.toDate(), Conditions.withinPast(minutesAmount));
    }

    public static Condition withinHours(String column, int hoursAmount) {
        LocalDateTime now = LocalDateTime.now().minusHours(hoursAmount);
        return Conditions.withinDate(column, now.toDate(), Conditions.withinPast(hoursAmount));
    }

    public static Condition withinDays(String column, int daysAmount) {
        LocalDateTime now = LocalDateTime.now().minusDays(daysAmount);
        return Conditions.withinDate(column, now.toDate(), Conditions.withinPast(daysAmount));
    }

    public static Condition withinWeeks(String column, int weeksAmount) {
        LocalDateTime now = LocalDateTime.now().minusWeeks(weeksAmount);
        return Conditions.withinDate(column, now.toDate(), Conditions.withinPast(weeksAmount));
    }

    public static Condition withinMonths(String column, int monthsAmount) {
        LocalDateTime now = LocalDateTime.now().minusMonths(monthsAmount);
        return Conditions.withinDate(column, now.toDate(), Conditions.withinPast(monthsAmount));
    }

    public static Condition withinYears(String column, int yearsAmount) {
        LocalDateTime now = LocalDateTime.now().minusYears(yearsAmount);
        return Conditions.withinDate(column, now.toDate(), Conditions.withinPast(yearsAmount));
    }

    private static Condition withinDate(String column, Date date, boolean past) {
        return past ? Conditions.fromDateToNow(column, date) : Conditions.fromNowToDate(column, date);
    }

    private static Condition fromDateToNow(String column, Date date) {
        return Conditions.and(Conditions.ge(column, date), Conditions.le(column, new Date()));
    }

    private static Condition fromNowToDate(String column, Date date) {
        return Conditions.and(Conditions.le(column, date), Conditions.ge(column, new Date()));
    }

    private static boolean withinPast(int value) {
        return value >= 0;
    }
}

