/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.query;

import com.google.common.collect.Iterables;
import com.suncode.dbexplorer.database.query.Condition;
import com.suncode.dbexplorer.database.query.QueryContext;
import com.suncode.dbexplorer.database.query.QueryParameter;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class AndOrCondition
implements Condition {
    private final Type type;
    private final Condition[] conditions;

    public AndOrCondition(Type type, Condition ... conditions) {
        Assert.notNull((Object)((Object)type), (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)conditions, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.type = type;
        this.conditions = conditions;
    }

    @Override
    public String toSql(QueryContext queryContext) {
        ArrayList<String> conditionsSql = new ArrayList<String>();
        for (Condition condition : this.conditions) {
            conditionsSql.add(condition.toSql(queryContext));
        }
        StringBuilder sql = new StringBuilder().append("(").append(StringUtils.join(conditionsSql, (String)(" " + this.type.name() + " "))).append(")");
        return sql.toString();
    }

    @Override
    public QueryParameter[] getParameters(QueryContext queryContext) {
        ArrayList parameters = new ArrayList();
        for (Condition condition : this.conditions) {
            QueryParameter[] params = condition.getParameters(queryContext);
            Collections.addAll(parameters, params);
        }
        return (QueryParameter[])Iterables.toArray(parameters, QueryParameter.class);
    }

    public static enum Type {
        AND,
        OR;

    }
}

