/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.query;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.internal.DatabaseImplementor;
import com.suncode.dbexplorer.database.schema.TableSchema;

public abstract class AbstractQuery {
    protected final DatabaseSession session;
    protected final DatabaseImplementor implementor;
    protected TableSchema rootTable;

    public AbstractQuery(DatabaseSession session, DatabaseImplementor implementor) {
        this.session = session;
        this.implementor = implementor;
    }

    public TablePathInfo getPathInfo(String value) {
        String[] splited = value.split("\\.");
        if (splited.length == 1) {
            return new TablePathInfo(this.session.getDatabase().getDefaultSchemaName(), value);
        }
        if (splited.length == 2) {
            return new TablePathInfo(splited[0], splited[1]);
        }
        throw new IllegalArgumentException("Invalid table name: " + value + ".");
    }

    public static class TablePathInfo {
        private String schema;
        private String name;

        TablePathInfo(String schema, String name) {
            this.schema = schema;
            this.name = name;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getName() {
            return this.name;
        }
    }
}

