/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.postgres.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BooleanTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class PostgresBitType
extends AbstractSingleColumnStandardBasicType<Boolean> {
    public static final PostgresBitType INSTANCE = new PostgresBitType();

    private PostgresBitType() {
        super((SqlTypeDescriptor)BitTypeDescriptor.INSTANCE, (JavaTypeDescriptor)BooleanTypeDescriptor.INSTANCE);
    }

    public String getName() {
        return "bit";
    }

    static class BitTypeDescriptor
    implements SqlTypeDescriptor {
        public static final BitTypeDescriptor INSTANCE = new BitTypeDescriptor();

        BitTypeDescriptor() {
        }

        public int getSqlType() {
            return 1111;
        }

        public boolean canBeRemapped() {
            return true;
        }

        public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    Boolean boolValue = (Boolean)javaTypeDescriptor.unwrap(value, Boolean.class, options);
                    st.setObject(index, boolValue != null ? "B" + (boolValue != false ? "1" : "0") : null, 1111);
                }

                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                }
            };
        }

        public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicExtractor<X>(javaTypeDescriptor, this){

                protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap(rs.getObject(name), options);
                }

                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return null;
                }

                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return null;
                }
            };
        }
    }
}

