/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.db2;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.internal.db2.DB2DataTypeRegistry;
import com.suncode.dbexplorer.database.internal.schema.jdbc.JdbcSchemaLoader;
import com.suncode.dbexplorer.database.schema.Sequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DB2SchemaLoader
extends JdbcSchemaLoader {
    DB2DataTypeRegistry dataTypeRegistry;

    @Autowired
    public DB2SchemaLoader(DB2DataTypeRegistry dataTypeRegistry) {
        super(dataTypeRegistry);
    }

    @Override
    protected List<Sequence> readSequences(DatabaseSession session, String schemaName) {
        List results = session.hibernateSession().createSQLQuery("select seqname from SYSIBM.SYSSEQUENCES WHERE DEFINERTYPE = 'U'").addScalar("seqname", (Type)StandardBasicTypes.STRING).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
        ArrayList sequences = Lists.newArrayList();
        for (Map row : results) {
            String sequenceName = (String)row.get("seqname");
            sequences.add(new Sequence(sequenceName));
        }
        return sequences;
    }
}

