/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.db2;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.internal.db2.DB2ConnectionUrlResolver;
import com.suncode.dbexplorer.database.internal.db2.DB2DataTypeRegistry;
import com.suncode.dbexplorer.database.internal.db2.DB2SchemaLoader;
import com.suncode.dbexplorer.database.internal.support.AbstractDatabaseImplementor;
import java.util.List;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DB2Database
extends AbstractDatabaseImplementor {
    private static final Logger log = LoggerFactory.getLogger(DB2Database.class);

    @Autowired
    public DB2Database(DB2SchemaLoader schemaLoader, DB2ConnectionUrlResolver urlResolver, DB2DataTypeRegistry typeRegistry) {
        super(DatabaseType.DB2, schemaLoader, urlResolver, typeRegistry);
    }

    @Override
    protected String getDriverClassName() {
        return "com.ibm.db2.jcc.DB2Driver";
    }

    @Override
    public String getCurrentSchemaName(DatabaseSession session) {
        return (String)session.hibernateSession().createSQLQuery("select current_schema as schema from sysibm.sysdummy1").addScalar("schema", (Type)StandardBasicTypes.STRING).uniqueResult();
    }

    @Override
    public List<String> getSchemasNames(DatabaseSession session) {
        return session.hibernateSession().createSQLQuery("select schemaname AS schema from syscat.schemata WHERE DEFINERTYPE = 'U' AND schemaname not in ('NULLID ','SQLJ', 'SYSTOOLS' )").addScalar("schema", (Type)StandardBasicTypes.STRING).list();
    }
}

