/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal;

import com.google.common.collect.Maps;
import com.suncode.dbexplorer.alias.util.SystemConnectionStringResolver;
import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseFactory;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.internal.DatabaseAvailabilityResolver;
import com.suncode.dbexplorer.database.internal.DatabaseConnectionTestResult;
import com.suncode.dbexplorer.database.internal.DatabaseImpl;
import com.suncode.dbexplorer.database.internal.DatabaseImplementor;
import com.suncode.plugin.framework.service.Provides;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.stereotype.Component;

@Component
@Provides(value={DatabaseFactory.class})
public class DatabaseFactoryImpl
implements DatabaseFactory {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DatabaseAvailabilityResolver availabilityResolver;
    private Map<ConnectionString, Database> dbCache = Maps.newHashMap();

    @Override
    public Database create(ConnectionString connectionString) {
        return this.create(connectionString, false);
    }

    @Override
    public Database create(ConnectionString connectionString, boolean force) {
        Database database = this.dbCache.get(connectionString);
        if (database != null) {
            if (force) {
                this.closeConnection(database);
                this.dbCache.remove(connectionString);
            } else {
                return database;
            }
        }
        DatabaseImplementor implementor = this.resolveDatabaseType(connectionString);
        DataSource dataSource = this.prepareDataSource(connectionString, implementor);
        database = new DatabaseImpl(dataSource, implementor, connectionString.getSchema(), this.availabilityResolver.testConnection(connectionString, dataSource).getSuccess());
        this.dbCache.put(connectionString, database);
        return database;
    }

    @Override
    public DatabaseConnectionTestResult testConnection(ConnectionString connectionString) {
        DatabaseImplementor implementor = this.resolveDatabaseType(connectionString);
        DataSource dataSource = this.prepareDataSource(connectionString, implementor);
        return this.availabilityResolver.testConnection(connectionString, dataSource);
    }

    @Override
    public boolean isAvailable(ConnectionString connectionString) {
        return this.testConnection(connectionString).getSuccess();
    }

    private void closeConnection(Database db) {
        ((DatabaseImpl)db).close();
    }

    public DatabaseImplementor resolveDatabaseType(ConnectionString connectionString) {
        Map impls = this.applicationContext.getBeansOfType(DatabaseImplementor.class);
        for (DatabaseImplementor impl : impls.values()) {
            DatabaseType type;
            if (!impl.handles(type = StringUtils.isNotBlank((String)connectionString.getJdbcUrl()) ? DatabaseType.parseScheme(SystemConnectionStringResolver.parseJdbcUrl(connectionString.getJdbcUrl()).getScheme()) : connectionString.getType())) continue;
            return impl;
        }
        throw new IllegalStateException("Not yet supported");
    }

    private DataSource prepareDataSource(ConnectionString connectionString, DatabaseImplementor implementor) {
        SimpleDriverDataSource dataSource = new SimpleDriverDataSource();
        String url = StringUtils.isNotBlank((String)connectionString.getJdbcUrl()) ? connectionString.getJdbcUrl() : implementor.buildConnectionUrl(connectionString);
        dataSource.setUrl(url);
        dataSource.setUsername(connectionString.getUser());
        dataSource.setPassword(connectionString.getPassword());
        dataSource.setDriverClass(implementor.getDriverClass());
        return dataSource;
    }

    @PreDestroy
    public void cleanup() {
        for (Database db : this.dbCache.values()) {
            this.closeConnection(db);
        }
    }
}

