/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database;

import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class RecordId {
    private boolean composite;
    private Object singleValue;
    private Map<String, Object> compositeValues;

    private RecordId(Object value) {
        this.composite = false;
        this.singleValue = value;
    }

    private RecordId(Map<String, Object> values) {
        Assert.notEmpty(values, (String)"[Assertion failed] - this map must not be empty; it must contain at least one entry");
        Assert.isTrue((values.size() > 1 ? 1 : 0) != 0, (String)"[Assertion failed] - this expression must be true");
        this.composite = true;
        this.compositeValues = values;
    }

    public static RecordId single(Object value) {
        Assert.notNull((Object)value, (String)"[Assertion failed] - this argument is required; it must not be null");
        return new RecordId(value);
    }

    public static RecordId composite(Map<String, Object> values) {
        if (values.size() == 1) {
            return new RecordId(Iterables.getFirst(values.values(), null));
        }
        return new RecordId(values);
    }

    public static Composite buildComposite() {
        return new Composite();
    }

    public Object getSingleValue() {
        Assert.state((!this.composite ? 1 : 0) != 0, (String)"This IS composite id: check this with isComposite() method first!");
        return this.singleValue;
    }

    public Map<String, Object> getCompositeValues() {
        Assert.state((boolean)this.composite, (String)"This is NOT composite id: check this with isComposite() method first!");
        return this.compositeValues;
    }

    public boolean isComposite() {
        return this.composite;
    }

    public static class Composite {
        private Map<String, Object> values = new LinkedHashMap<String, Object>();

        public Composite add(String column, Object value) {
            this.values.put(column, value);
            return this;
        }

        public RecordId get() {
            if (this.values.size() > 1) {
                return RecordId.composite(this.values);
            }
            return RecordId.single(Iterables.getFirst(this.values.values(), null));
        }
    }
}

