/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.configurationtransfer.dto.alias;

import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.TablesSet;
import com.suncode.dbexplorer.alias.settings.TableSettings;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.ConfigurationAliasDto;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.ConfigurationConnectionStringDomainDto;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.settings.ConfigurationTableSettingConverter;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.settings.ConfigurationTableSettingDto;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.tableset.ConfigurationTablesSetConverter;
import com.suncode.dbexplorer.configurationtransfer.dto.alias.tableset.ConfigurationTablesSetDto;
import com.suncode.dbexplorer.database.ConnectionStringDomain;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationAliasConverter {
    private final ConfigurationTablesSetConverter configurationTablesSetConverter;
    private final ConfigurationTableSettingConverter configurationTableSettingConverter;

    public List<ConfigurationAliasDto> convertToDto(List<Alias> aliases) {
        return aliases.stream().map(this::convertToDto).collect(Collectors.toList());
    }

    private ConfigurationAliasDto convertToDto(Alias alias) {
        ConfigurationConnectionStringDomainDto connectionString = alias.getIsSystemAlias() != false ? null : new ConfigurationConnectionStringDomainDto(alias.getId(), alias.getConnectionStringDomain().getType(), alias.getConnectionStringDomain().getCatalog(), alias.getConnectionStringDomain().getSchema(), alias.getConnectionStringDomain().getHost(), alias.getConnectionStringDomain().getPort(), alias.getConnectionStringDomain().getUser(), alias.getConnectionStringDomain().getPassword(), alias.getConnectionStringDomain().getJdbcUrl());
        ConfigurationAliasDto aliasDto = new ConfigurationAliasDto(alias.getName(), alias.getName(), connectionString, alias.getIsActive(), alias.getLogging(), alias.getIsSystemAlias());
        List<ConfigurationTablesSetDto> tablesSets = this.configurationTablesSetConverter.convertToDto(alias.getTablesSets());
        aliasDto.getTableSets().getList().addAll(tablesSets);
        List<ConfigurationTableSettingDto> tableSettings = this.configurationTableSettingConverter.convertToDto(alias.getSettings().getTablesSettings());
        aliasDto.getSettings().getList().addAll(tableSettings);
        return aliasDto;
    }

    public Alias convertToEntity(ConfigurationAliasDto aliasDto, List<User> allUsersInBase, List<UserGroup> allGroupsInBase) {
        ConnectionStringDomain connectionStringDomain = aliasDto.isSystemAlias() ? null : ConnectionStringDomain.builder().type(aliasDto.getConnectionString().getType()).catalog(aliasDto.getConnectionString().getCatalog()).schema(aliasDto.getConnectionString().getSchema()).host(aliasDto.getConnectionString().getHost()).port(aliasDto.getConnectionString().getPort()).user(aliasDto.getConnectionString().getUser()).password(aliasDto.getConnectionString().getPassword()).jdbcUrl(aliasDto.getConnectionString().getJdbcUrl()).build();
        Alias alias = new Alias(aliasDto.getName(), connectionStringDomain);
        alias.setIsActive(BooleanUtils.toBooleanDefaultIfNull((Boolean)aliasDto.isActive(), (boolean)true));
        alias.setLogging(BooleanUtils.toBooleanDefaultIfNull((Boolean)alias.getLogging(), (boolean)true));
        if (aliasDto.getTableSets().getMetadata().isSelected()) {
            this.addTableSets(aliasDto.getTableSets().getList(), alias, allUsersInBase, allGroupsInBase);
        }
        if (aliasDto.getSettings().getMetadata().isSelected()) {
            this.addSettings(aliasDto.getSettings().getList(), alias);
        }
        return alias;
    }

    private void addTableSets(List<ConfigurationTablesSetDto> tablesSetDtos, Alias alias, List<User> allUsersInBase, List<UserGroup> allGroupsInBase) {
        for (ConfigurationTablesSetDto tablesSetDto : tablesSetDtos) {
            if (!tablesSetDto.getMetadata().isSelected()) continue;
            TablesSet tableSet = this.configurationTablesSetConverter.convertToEntity(tablesSetDto, allUsersInBase, allGroupsInBase);
            alias.addTablesSet(tableSet);
        }
    }

    private void addSettings(List<ConfigurationTableSettingDto> tableSettingsDtos, Alias alias) {
        for (ConfigurationTableSettingDto tableSettingDto : tableSettingsDtos) {
            TableSettings tableSettings = this.configurationTableSettingConverter.convertToEntity(tableSettingDto);
            alias.getSettings().addTablesSettings(tableSettings);
        }
    }

    @Autowired
    public ConfigurationAliasConverter(ConfigurationTablesSetConverter configurationTablesSetConverter, ConfigurationTableSettingConverter configurationTableSettingConverter) {
        this.configurationTablesSetConverter = configurationTablesSetConverter;
        this.configurationTableSettingConverter = configurationTableSettingConverter;
    }
}

