/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.alias.settings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.suncode.dbexplorer.alias.settings.ColumnSettings;
import jakarta.persistence.Transient;
import java.util.Collections;
import java.util.Map;
import org.springframework.util.Assert;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TableSettings {
    private String schemaName;
    private String tableName;
    private String displayName;
    private boolean logging;
    @Transient
    private Map<String, ColumnSettings> columnsSettings = Maps.newHashMap();

    @JsonCreator
    public TableSettings(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName) {
        Assert.hasText((String)tableName, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public Map<String, ColumnSettings> getColumnsSettings() {
        return Collections.unmodifiableMap(this.columnsSettings);
    }

    public ColumnSettings getColumnSettings(String columnName) {
        ColumnSettings settings = this.columnsSettings.get(columnName);
        if (settings == null) {
            settings = new ColumnSettings(columnName);
            this.addColumnSettings(settings);
        }
        return settings;
    }

    public void addColumnSettings(ColumnSettings settings) {
        this.columnsSettings.put(settings.getColumnName(), settings);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }
}

